/*  Comman variables for card settings  */

#ifndef   ct_io_addx
     extern   unsigned	 near	   ct_io_addx ;
     extern   unsigned	 near	   ct_int_num ;
     extern   unsigned   near      ct_dma_channel ;
     extern   unsigned   near      wCardID ;
#endif


#ifndef   NO_ERROR
     #define NO_ERROR		 0
#endif


/*  Voice I/O status  */
extern unsigned near ct_voice_status ;


/*  Function prototypes for Memory Voice Driver routines */

unsigned    ctvm_version(void) ;
int         ctvm_init(void) ;
void        ctvm_speaker( int on_off_flag );
int         ctvm_input( char far *buffer_ptr, unsigned long buffer_size,
                        unsigned sampling_rate );
int         ctvm_output( char far *buffer_ptr );
void        ctvm_stop( void );
int         ctvm_pause( void );
int         ctvm_continue( void );
int         ctvm_break_loop( int break_mode );
void        ctvm_terminate( void );
int         ctvm_outputxms( unsigned xms_handle, unsigned long xms_offset );
int         ctvm_inputxms( unsigned xms_handle, unsigned sampling_rate,
                           unsigned long xms_offset, unsigned buffer_length );
int         ctvm_get_cardtype( void );
unsigned long   ctvm_get_ADC_range( int mode );
unsigned long   ctvm_get_DAC_range( int mode );
int         ctvm_set_stereo( int mode );
int         ctvm_set_input_source( int source );
int         ctvm_set_input_freq( int freq );
int         ctvm_ANFI_control( int option );
int         ctvm_DNFI_control( int option );
int         ctvm_get_ANFI( void );
int         ctvm_get_DNFI( void );


/*  Function prototypes for Disk Double-Buffering Voiec Driver routines  */
unsigned    ctvd_version( void );
int         ctvd_init( int buffer_size );
void        ctvd_speaker( int on_off_flag );
int         ctvd_input( int file_handle, unsigned sampling_rate );
int         ctvd_output( int file_handle );
void        ctvd_stop( void );
void        ctvd_pause( void );
void        ctvd_continue( void );
void        ctvd_break_loop( int break_mode );
void        ctvd_terminate( void );
int         ctvd_drv_error( void );
int         ctvd_ext_error( void );
void        ctvd_buffer_addx( char far *buffer, int buffer_size );
int         ctvd_get_cardtype( void );
unsigned long   ctvd_get_ADC_range( int mode );
unsigned long   ctvd_get_DAC_range( int mode );
int         ctvd_set_stereo( int mode );
int         ctvd_set_input_source( int source );
int         ctvd_set_input_freq( int freq );
int         ctvd_ANFI_control( int option );
int         ctvd_DNFI_control( int option );
int         ctvd_get_ANFI( void );
int         ctvd_get_DNFI( void );


/*  Creative Voice file header structure  */

typedef   struct
    {
        char       id[20] ;
        unsigned   voice_offset ;
        unsigned   version ;
        unsigned   check_code ;
     } VOCHDR ;
